-- SEQUENCE: public.ActiveStatus_ActiveStatusId_seq

-- DROP SEQUENCE IF EXISTS public."ActiveStatus_ActiveStatusId_seq";

CREATE SEQUENCE IF NOT EXISTS public."ActiveStatus_ActiveStatusId_seq"
    INCREMENT 1
    START 1
    MINVALUE 1
    MAXVALUE 9223372036854775807
    CACHE 1;

ALTER SEQUENCE public."ActiveStatus_ActiveStatusId_seq"
    OWNER TO postgres;
	
-- Table: public.ActiveStatus

-- DROP TABLE IF EXISTS public."ActiveStatus";

CREATE TABLE IF NOT EXISTS public."ActiveStatus"
(
    "ActiveStatusId" integer NOT NULL DEFAULT nextval('"ActiveStatus_ActiveStatusId_seq"'::regclass),
    "Name" character varying(150) COLLATE pg_catalog."default" NOT NULL,
    CONSTRAINT "ActiveStatus_pkey" PRIMARY KEY ("ActiveStatusId")
)

TABLESPACE pg_default;
--------------------------------------------------
ALTER TABLE IF EXISTS public."ActiveStatus"
    OWNER to postgres;

INSERT INTO public."ActiveStatus"(
	"ActiveStatusId", "Name")
	VALUES (1,'Active'),(2,'InActive');
---------------------------------------------------	
INSERT INTO public."LogType"(
	"LogTypeId", "LogTypeName","Active")
	VALUES (66,'Cubicle',true);


-- ----------------------------
-- Table structure for Cubicle
-- ----------------------------
CREATE SEQUENCE "Cubicle_CubicleId_seq";
DROP TABLE IF EXISTS "public"."Cubicle";
CREATE TABLE "public"."Cubicle" (
  "CubicleId" int4 NOT NULL DEFAULT nextval('"Cubicle_CubicleId_seq"'::regclass),
  "Name" varchar(150) COLLATE "pg_catalog"."default" NOT NULL,
  "ProviderId" int4,
  "CreatedBy" int4 NOT NULL,
  "CreatedDate" timestamptz(6) NOT NULL,
  "ModifiedBy" int4,
  "ModifiedDate" timestamptz(6),
  "ActiveStatusId" int4 NOT NULL
)
;

-- ----------------------------
-- Primary Key structure for table Cubicle
-- ----------------------------
ALTER TABLE "public"."Cubicle" ADD CONSTRAINT "Cubicle_pkey" PRIMARY KEY ("CubicleId");

-- ----------------------------
-- Foreign Keys structure for table Cubicle
-- ----------------------------
ALTER TABLE "public"."Cubicle" ADD CONSTRAINT "FK_Cubicle_ActiveStatusId" FOREIGN KEY ("ActiveStatusId") REFERENCES "public"."ActiveStatus" ("ActiveStatusId") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."Cubicle" ADD CONSTRAINT "FK_Cubicle_CreatedBy" FOREIGN KEY ("CreatedBy") REFERENCES "public"."Account" ("AccountId") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."Cubicle" ADD CONSTRAINT "FK_Cubicle_ModifiedBy" FOREIGN KEY ("ModifiedBy") REFERENCES "public"."Account" ("AccountId") ON DELETE CASCADE ON UPDATE NO ACTION;
ALTER TABLE "public"."Cubicle" ADD CONSTRAINT "FK_Cubicle_ProviderId" FOREIGN KEY ("ProviderId") REFERENCES "public"."Provider" ("ProviderId") ON DELETE CASCADE ON UPDATE NO ACTION;
